﻿using System.Collections.Concurrent;

public class ImagingService
{
    private readonly EndpointStatusCheckService _endpointStatusCheckService;
    private readonly StationConfigurationService _stationConfigurationService;
    private readonly StudyService _studyService;

    private readonly PatientRepository _patientRepository;

    private readonly ConcurrentDictionary<string, StationConfiguration> _stationConfigurationMap;

    public ImagingService()
    {
        _endpointStatusCheckService = new EndpointStatusCheckService();
        _stationConfigurationService = new StationConfigurationService();

        _stationConfigurationMap = _stationConfigurationService.GetConfigurationMap();

        _studyService = new StudyService(_stationConfigurationMap);

        _patientRepository = new PatientRepository();
    }

    public void InsertUpdatePatientStudies(string patientIcn, int patientId)
    {
        _studyService.InsertUpdatePatientStudies(patientIcn, patientId);
    }

    public bool ServicesAvailable(int patientId)
    {
        var station = _patientRepository.GetStationNumberForPatient(patientId);

        if (_stationConfigurationMap.ContainsKey(station))
        {
            var url = _stationConfigurationMap[station].GetServiceStatusUrl;
            if (!string.IsNullOrEmpty(url))
                return _endpointStatusCheckService.ServiceAvailable(url);
        }

        return false;
    }
}